unit RgUtil;

interface

uses
  Winapi.Windows, System.Types, System.SysUtils, System.Variants,
  System.Generics.Collections,
  System.Classes, json, RgReaderApi, RgReaderApiType, RgReaderApiDef,
  xmldoc, XMLIntf;

function BufferToHexString(Buffer: TBytes): string;
function ArrayToHexString(Buf: Pointer; Len: Integer): string;
function HexStringToBuffer(HexString: string): TBytes;
procedure HexStringToArray(key: string; Buf: Pbyte; Len: byte);
function CardUid2Code(cardUid: TRG_CARD_UID): string;
function GetLasrErrorr(err: Tapi_error): string;

implementation

const
  FReverseCodeUid = false;
  FLengthCode = 7;

function BufferToHexString(Buffer: TBytes): string;
var
  i: Integer;
begin
  Result := '';
  for i := 0 to length(Buffer) - 1 do
    Result := Result + IntToHex(Buffer[i], 2);
  Result := trim(Result);
end;

function ArrayToHexString(Buf: Pointer; Len: Integer): string;
var
  Buffer: TBytes;
begin
  if Len = 0 then
    exit;
  setlength(Buffer, Len);
  move(Buf^, Buffer[0], Len);
  Result := BufferToHexString(Buffer);
end;

function HexStringToBuffer(HexString: string): TBytes;
  function HexChrVal(HexChr: char): byte;
  begin
    HexChr := UpCase(HexChr);
    case HexChr of
      '0' .. '9':
        Result := byte(HexChr) - byte('0');
      'A' .. 'F':
        Result := byte(HexChr) - byte('A') + 10;
    else
      Result := $FF;
    end;
  end;

var
  i: Integer;
  s, s2, s3: string;
const
  HexChars = ['0' .. '9', 'A' .. 'F'];
begin
  s3 := '';
  s := UpperCase(HexString);
  for i := 1 to length(s) do
    if CharInSet(s[i], HexChars) then
      s3 := s3 + s[i];
  s := s3;
  if length(s) mod 2 <> 0 then
    s := '0' + s;
  setlength(Result, (length(s) div 2));
  for i := 0 to length(Result) - 1 do
  begin
    s2 := copy(s, 2 * i + 1, 2);
    Result[i] := (HexChrVal(s2[1]) * 16) + HexChrVal(s2[2]);
  end;
end;

procedure HexStringToArray(key: string; Buf: Pbyte; Len: byte);
var
  i, k: Integer;
  Data: TBytes;
begin
  Data := HexStringToBuffer(key);
  k := Len;
  // if length(Data) < Len then
  // k := length(Data);
  for i := 0 to k - 1 do
  begin
    if i < length(Data) then
    begin
      Buf^ := Data[i];
      inc(Buf);
    end
    else
    begin
      Buf^ := 0;
      inc(Buf);
    end;
  end;
end;

function CardUid2Code(cardUid: TRG_CARD_UID): string;
var
  i: Integer;
  key, key1, key2: int64;
begin
  Result := '';
  key := 0;
  if not FReverseCodeUid then
  begin
    for i := 0 to FLengthCode - 1 do
    begin
      // key1 := 0;
      // key2 := 0;
      key1 := cardUid[i];
      key2 := key1 shl (8 * i);
      key := key + key2;
    end;
  end
  else
  begin
    for i := FLengthCode - 1 downto 0 do
    begin
      // key1 := 0;
      // key2 := 0;
      key1 := cardUid[i];
      key2 := key1 shl (8 * (FLengthCode - 1 - i));
      key := key + key2;
    end;
  end;
  if key > 0 then
    Result := inttostr(key);
end;

function GetLasrErrorr(err: Tapi_error): string;
var
  Error: string;
begin

  case Terror(err) of
    EC_OK:
      Error := ' ';
    EC_FAIL:
      Error := ' ';
    EC_NOT_IMPLEMENTED:
      Error := '  ';
    EC_BAD_ARGUMENT:
      Error := '    ';
    EC_INVALID_HANDLE:
      Error := '   ,   ';
    EC_INVALID_CONNECTION_TYPE:
      Error := '   ';
    EC_INVALID_CONNECTION_ADDRESS:
      Error := '     ';
    EC_INVALID_DEVICE_ADDRESS:
      Error := '        ';
    EC_DEVICE_OPERATION_UNSUPPORTED:
      Error := '    ';
    EC_DEVICE_NOT_CONNECTED:
      Error := '      ( USB )';
    EC_DEVICE_NO_RESPOND:
      Error := '    ';
    EC_DEVICE_COMM_FAILURE:
      Error := '    ';
    EC_DEVICE_PROTOCOL_FAILURE:
      Error := '     ';
    EC_POLL_NO_EVENTS:
      Error := '  ';
    EC_POLL_QUEUE_CLOSED:
      Error := '   ';
    EC_CALL_INIT:
      Error := '  ';
    EC_DEVICE_INVALID_COMMAND:
      Error := '       ';
    EC_DEVICE_INVALID_PARAM:
      Error := '   ';
    EC_DEVICE_INVALID_PIN:
      Error := ' PIN   ';
    EC_DEVICE_COMMAND_TIMEOUT:
      Error := '       ';
    EC_DEVICE_NO_CARD:
      Error := '   ';
    EC_DEVICE_UNKNOWN_CARD:
      Error := '    ';
    EC_DEVICE_INCOMPATIBLE_CARD:
      Error := '    ';
    EC_DEVICE_AUTH_FAIL:
      Error := '   ';
    EC_DEVICE_PROFILE_FAIL:
      Error := '  ';
    EC_DEVICE_RW_FAIL:
      Error := '   ';
    EC_IO_OPEN_FAIL:
      Error := '   ';
    EC_IO_CLOSE_FAIL:
      Error := '   ';
    EC_IO_READ_FAIL:
      Error := '   ';
    EC_IO_WRITE_FAIL:
      Error := '   ';
    EC_IO_CLOSED:
      Error := ' ,   ';
    DEVICE_IN_BOOT:
      Error := '   BOOT';
    ERROR_MODEL:
      Error := '     ';
    FILE_NOT_FOUND:
      Error := '  ';
  end;
  Result := Error;
end;

end.
